/*
 * Decompiled with CFR 0.152.
 */
package ptqi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp4.Mrp;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.IdentityHashSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.errlog.ErrorLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ptqi.RuntimeInterruptedException;

public class PlantuneDllMrp
extends Mrp {
    private final GeneralizedOrderRequest.Limits limits;
    private final ErrorLog errorLog;
    private final Set<GeneralizedOrderRequest> priorityUpdated;
    HashSet<GeneralizedOrderRequest> alreadyPoppedPhantomGors;
    HashSet<GeneralizedOrderRequest> alreadyRegisteredPhantomGors;
    Map<Product, List<Product>> prod2phantom;
    Map<Product, List<Product>> phantomParts;

    public PlantuneDllMrp(@Nonnull Superplan superplan, @Nonnull ErrorLog errorLog) {
        super(superplan, PlantuneDllMrp.createParameters());
        this.errorLog = errorLog;
        this.limits = new GeneralizedOrderRequest.Limits();
        this.priorityUpdated = new IdentityHashSet<GeneralizedOrderRequest>();
        this.prod2phantom = new HashMap<Product, List<Product>>();
        this.phantomParts = new HashMap<Product, List<Product>>();
        this.registerPhantoms();
        this.alreadyPoppedPhantomGors = new HashSet();
        this.alreadyRegisteredPhantomGors = new HashSet();
    }

    private static Mrp.MrpParameters createParameters() {
        Mrp.MrpParameters p = new Mrp.MrpParameters();
        p.priorityShift = 0L;
        p.unaddressedShift = 31536000000L;
        p.opBuffer = 0L;
        p.bomStepBuffer = 0L;
        p.materialBuffer = 0L;
        return p;
    }

    @Override
    protected void collectGors() {
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            Product p = gor.getProduct();
            if (!gor.hasSelectedActiongram()) {
                gor.setActiongram(p.getDefaultActiongram());
            }
            Mrp.ProductInfo info = this.getProductInfo(p);
            info.gors.add(gor);
            if (!this.isPhantom(p)) continue;
            Collection phantomParts = this.phantomParts.get(p);
            for (Product phantomProd : phantomParts) {
                Mrp.ProductInfo phantomInfo = this.getProductInfo(phantomProd);
                phantomInfo.gors.add(gor);
            }
        }
    }

    protected void registerPhantoms() {
        this.prod2phantom = new HashMap<Product, List<Product>>();
        this.phantomParts = new HashMap<Product, List<Product>>();
        for (Product product : this.superplan.getShopConf().getProducts()) {
            List<MaterialQuantity> producings = product.getDefaultActiongram().getRootAction().getProduces();
            if (producings.size() <= 1) continue;
            this.phantomParts.put(product, new ArrayList());
            for (MaterialQuantity producingItem : producings) {
                Material producing = producingItem.getMaterial();
                if (!(producing instanceof Product)) continue;
                Product producingProd = (Product)producing;
                this.phantomParts.get(product).add(producingProd);
                if (!this.prod2phantom.containsKey(producingProd)) {
                    this.prod2phantom.put(producingProd, new ArrayList());
                }
                this.prod2phantom.get(producingProd).add(product);
            }
        }
    }

    protected boolean isPhantom(Product p) {
        return this.phantomParts.containsKey(p);
    }

    protected boolean isPhantomPart(Product p) {
        return this.prod2phantom.containsKey(p);
    }

    @Override
    @Nonnull
    protected GeneralizedOrderRequest popGor(@Nonnull Mrp.ProductInfo info) {
        GeneralizedOrderRequest gor = info.gors.removeFirst();
        Preconditions.checkState(gor.hasSelectedActiongram());
        if (this.isPhantom(gor.getProduct())) {
            if (this.alreadyPoppedPhantomGors.contains(gor)) {
                return gor;
            }
            this.alreadyPoppedPhantomGors.add(gor);
        }
        for (GeneralizedActionRequest gar : gor.getGars()) {
            double qty = gar.getRequestedQty() - gar.getOutOfPlanQty();
            if (!(qty > 0.0)) continue;
            for (MaterialQuantity mq : gar.getAction().getProduces()) {
                if (!(mq.getMaterial() instanceof Product)) continue;
                Product p = (Product)mq.getMaterial();
                Mrp.ProductInfo pi = this.getProductInfo(p);
                pi.stockQty += mq.getQty() * qty;
                pi.stockSource = gar;
            }
        }
        return gor;
    }

    @Override
    protected void registerGor(@Nonnull GeneralizedOrderRequest gor, long dd) {
        if (this.alreadyRegisteredPhantomGors.contains(gor)) {
            if (dd < gor.getDueDate()) {
                gor.setDueDate(dd);
            }
            return;
        }
        this.alreadyRegisteredPhantomGors.add(gor);
        gor.setDueDate(dd);
        gor.setPriority(5);
        if (this.mrpOrderGorPd != null) {
            gor.setProperty(this.mrpOrderGorPd, this.processedGorsCnt);
        }
        ++this.processedGorsCnt;
        long shift = 0L;
        for (GeneralizedActionRequest gar : Lists.reverse(gor.getGars())) {
            Action action = gar.getAction();
            gar.setDueDate(dd - shift);
            long ttmWithRebuild = action.timeToMake(gar.getRequestedQty()) + this.superplan.getShopConf().getMaxRebuildTime(action);
            List<Workplace> availWorkplaces = this.superplan.getShopConf().getWorkplaces(action.getCapabilityReq());
            long minWpShift = Long.MAX_VALUE;
            for (Workplace wp : availWorkplaces) {
                long wpShift = this.getLpsShiftOnWorkplace(wp, ttmWithRebuild, gar.getDueDate());
                if (wpShift >= minWpShift) continue;
                minWpShift = wpShift;
            }
            shift = minWpShift < Long.MAX_VALUE ? (shift += minWpShift) : (shift += action.timeToMake(gar.getRequestedQty()));
            gar.setLatestPossibleStart(dd - shift);
            double qty = gar.getRequestedQty() - gar.getOutOfPlanMat();
            if (qty > 0.0) {
                for (MaterialQuantity mq : action.getBom()) {
                    if (mq.getMaterial() instanceof Product) {
                        Product p = (Product)mq.getMaterial();
                        Mrp.ProductInfo info = this.getProductInfo(p);
                        info.demands.add(new GarDemand(dd - shift - this.bomStepBuffer, mq.getQty() * qty, gar));
                        continue;
                    }
                    Mrp.MaterialInfo info = this.getMaterialInfo(mq.getMaterial());
                    if (info == null) continue;
                    info.demands.add(new GarDemand(dd - shift - this.materialBuffer, mq.getQty() * qty, gar));
                }
            }
            shift += action.getMinTimeToPrepare() + this.opBuffer;
        }
    }

    private long getLpsOnWorkplace(Workplace wp, long ttm, long lpe) {
        WorkplaceSchedule wps = this.superplan.getPlan().getWorkplaceSchedule(wp);
        Iterator<WorkplaceActivity> iter = wps.backwardIteratorWithBubbles(lpe, true);
        long t = ttm;
        long lps = lpe;
        while (iter.hasNext() && t > 0L) {
            WorkplaceActivity wpa = iter.next();
            if (wpa instanceof OfflineActivity) continue;
            long end = Math.min(wpa.getEnd(), lpe);
            long usable = end - wpa.getStart();
            if (usable < 0L) {
                usable = t;
            }
            long useT = Math.min(t, usable);
            t -= useT;
            lps = end - useT;
        }
        return lps;
    }

    private long getLpsShiftOnWorkplace(Workplace wp, long ttm, long lpe) {
        return lpe - this.getLpsOnWorkplace(wp, ttm, lpe);
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    protected List<Product> getSortedProducts() {
        ShopConfiguration conf = this.superplan.getShopConf();
        ArrayList<Tuple<Product, Product>> producingDeps = Lists.newArrayList();
        for (Product p : conf.getProducts()) {
            for (MaterialQuantity mq : p.getDefaultActiongram().getRootAction().getProduces()) {
                if (mq.getMaterial() == p || !(mq.getMaterial() instanceof Product)) continue;
                producingDeps.add(Tuple.create((Product)mq.getMaterial(), p));
            }
        }
        Tuple<List<Product>, Set<Product>> res = ShopConfiguration.topoSortProducts(conf.getProducts(), producingDeps);
        if (!res.getSecond().isEmpty()) {
            this.errorLog.add(2, "mrp.cycle_in_fiction_products", "cycle", res.getSecond());
            return conf.getSortedProducts();
        }
        return res.getFirst();
    }

    private static void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeInterruptedException();
        }
    }

    @Override
    protected void balance(@Nonnull Mrp.ProductInfo info) {
        PlantuneDllMrp.checkInterrupted();
        if (this.isPhantom(info.product)) {
            return;
        }
        long unaddressedTime = this.superplan.getFixationDate() + this.unaddressedShift;
        while (true) {
            double pairedQty;
            Mrp.Demand demand;
            if ((demand = info.demands.peekFirst()) != null && demand.qty <= 1.0E-7) {
                Mrp.Demand prevDemand = info.demands.removeFirst();
                demand = info.demands.peekFirst();
                if (demand != null) {
                    demand.qty += prevDemand.qty;
                }
            }
            while (info.stockQty <= 1.0E-7) {
                GeneralizedOrderRequest gor;
                if (info.gors.isEmpty()) {
                    if (demand == null) {
                        return;
                    }
                    gor = this.createGor(info);
                    if (gor == null) {
                        return;
                    }
                    info.gors.add(gor);
                    if (this.isPhantom(gor.getProduct())) {
                        Collection phantomParts = this.phantomParts.get(gor.getProduct());
                        for (Product phantomProd : phantomParts) {
                            Mrp.ProductInfo phantomInfo = this.getProductInfo(phantomProd);
                            if (phantomProd == info.product) continue;
                            phantomInfo.gors.add(gor);
                        }
                    }
                }
                gor = this.popGor(info);
                this.registerGor(gor, demand != null ? demand.date : unaddressedTime);
            }
            if (demand != null) {
                pairedQty = Math.min(demand.qty, info.stockQty);
                demand.qty -= pairedQty;
            } else {
                pairedQty = info.stockQty;
            }
            Preconditions.checkState(pairedQty > 1.0E-7, "Strange paired qty: %s", (Object)pairedQty);
            info.stockQty -= pairedQty;
            if (info.stockSource == null) continue;
            this.pair(info.stockSource, demand, (Material)info.product, pairedQty);
        }
    }

    @Override
    protected void balance(@Nonnull Mrp.MaterialInfo info) {
        PlantuneDllMrp.checkInterrupted();
        super.balance(info);
    }

    @Override
    @Nullable
    protected GeneralizedOrderRequest createGor(@Nonnull Mrp.ProductInfo info) {
        String id;
        double demandQty;
        Product p = info.product;
        if (p.getAggregationHorizon() == 0L) {
            demandQty = info.demands.getFirst().qty;
        } else {
            boolean finiteWindow = p.getAggregationHorizon() > 0L;
            long windowStart = info.demands.getFirst().date;
            long windowEnd = windowStart + p.getAggregationHorizon();
            demandQty = 0.0;
            for (Mrp.Demand d : info.demands) {
                if (finiteWindow && d.date >= windowEnd) break;
                demandQty += d.qty;
                d.date = windowStart;
            }
        }
        double qty = demandQty - info.stockQty;
        if (p.getMinBatch() > 0.0) {
            qty = Math.max(qty, p.getMinBatch());
        }
        if (p.getMaxBatch() > 0.0) {
            qty = Math.min(qty, p.getMaxBatch());
        }
        do {
            id = p.getName() + ":" + info.gorIndex;
            ++info.gorIndex;
        } while (this.superplan.getGor(id) != null);
        if (this.isPhantomPart(p)) {
            Product phantomProd = this.findSuitablePhantom(p);
            id = id + "-F";
            double producingQty = 1.0;
            for (MaterialQuantity producing : phantomProd.getDefaultActiongram().getRootAction().getProduces()) {
                if (producing.getMaterial() != p) continue;
                producingQty = producing.getQty();
            }
            p = phantomProd;
            qty = Math.ceil(qty / producingQty);
        }
        GeneralizedOrderRequest newGor = new GeneralizedOrderRequest(id, p, qty, this.superplan.getFixationDate(), this.superplan.getFixationDate(), GeneralizedOrderRequest.State.PROPOSED);
        Actiongram ag = p.getDefaultActiongram();
        if (!ag.getName().startsWith("*")) {
            this.errorLog.add(2, "mrp.no_valid_alternative", "product", p.getName());
            return null;
        }
        if (!this.limits.isActiongramQtyValid(qty, ag)) {
            this.errorLog.add(2, "mrp.manuf_too_long", "product", p.getName(), "qty", qty);
            return null;
        }
        newGor.setActiongram(ag);
        this.superplan.addGor(newGor);
        ++this.newGorsCnt;
        return newGor;
    }

    protected Product findSuitablePhantom(Product phantomPart) {
        Product p = this.prod2phantom.get(phantomPart).get(0);
        return p;
    }

    @Override
    protected void initInfo(@Nonnull Mrp.ProductInfo info, @Nonnull StoreSchedule ss) {
        super.initInfo(info, ss);
        Mrp.sortDeque(info.demands, Comparator.comparingInt(PlantuneDllMrp::getPriority).thenComparingLong(d -> d.date));
    }

    private static int getPriority(Mrp.Demand d) {
        if (d instanceof Mrp.CrDemand) {
            return ((Mrp.CrDemand)d).getCr().getPriority();
        }
        if (d instanceof GarDemand) {
            return ((GeneralizedOrderRequest)((GarDemand)d).gar.getParent()).getPriority();
        }
        return 10;
    }

    @Override
    @Nullable
    protected Mrp.MaterialInfo getMaterialInfo(Material m3) {
        return null;
    }

    @Override
    protected void pair(@Nullable GeneralizedActionRequest gar, Mrp.Demand demand, Material material, double qty) {
        if (gar == null) {
            return;
        }
        int priority = PlantuneDllMrp.getPriority(demand);
        GeneralizedOrderRequest gor = (GeneralizedOrderRequest)gar.getParent();
        if (this.priorityUpdated.contains(gor)) {
            gor.setPriority(Math.min(priority, gor.getPriority()));
        } else {
            gor.setPriority(priority);
            this.priorityUpdated.add(gor);
        }
    }

    protected static class GarDemand
    extends Mrp.Demand {
        public final GeneralizedActionRequest gar;

        protected GarDemand(long date, double qty, GeneralizedActionRequest gar) {
            super(date, qty);
            this.gar = gar;
        }

        public GeneralizedActionRequest getGar() {
            return this.gar;
        }
    }
}

